//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Optional Binding
//:
//: ## Task:
//:
//: Usually, we would use `let` to declare the variable used in optional binding.
//:
//: In the code below, change the `let` to a `var` and execute the code.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


let someValueToUnwrap: Int? = 56

// let constant - can't change its value
if let unwrappedValue = someValueToUnwrap {
    print(unwrappedValue)
}

// var variable - can change its value
if let unwrappedValue = someValueToUnwrap {
    print(unwrappedValue)
    // TODO: Change the let to a var
    unwrappedValue = 100
    print(unwrappedValue)
}


//:
//: -------------------
//:
//: * callout(💡 Tip):
//:     → We can shorten the code above.
//:
//:     If we use the same matching names for optional binding we can omit the assignment operator.
//:
//: We have done this in the code below.
//:
//: -------------------
//:


// using the same names
if let someValueToUnwrap {
    print(someValueToUnwrap)
}

// omitting the assignment operator
if var someValueToUnwrap {
    print(someValueToUnwrap)
    someValueToUnwrap = 100
    print(someValueToUnwrap)
}


//:
//: -------------------
//:
//: ## Task:
//:
//: Go back to the first piece of code.
//:
//: Rename the variables used in optional binding to match the names and omit the assignment operator.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:
